<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('codelist.currency', function (Blueprint $table) {
            $table->uuid('id')
                ->primary()
                ->default(DB::raw('gen_random_uuid()'))
                ->unique();
            $table->string('name')->unique();
            $table->timestamps();
        });
        DB::table('codelist.currency')->insert([
            'name' => 'EURO',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.currency')->insert([
            'name' => 'USD',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('codelist.currency')->insert([
            'name' => 'XAF',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('codelist.currency');
    }
};
