<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\EnsureHasAuthorizationHeader;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->validateCsrfTokens(
            except: ['api/*']
        );
        $middleware->append(EnsureHasAuthorizationHeader::class);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
         //$middleware->append(EnsureHasAuthorizationHeader::class);
    })->create();
